package ru.yandex.search.passport.korobochka;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class KorobochkaConfigBuilder
    extends AbstractKorobochkaConfigBuilder<
        KorobochkaConfigBuilder>
{
    public KorobochkaConfigBuilder()
        throws ConfigException
    {
        super(KorobochkaConfigDefaults.INSTANCE);
    }

    public KorobochkaConfigBuilder(
        final KorobochkaConfig config)
        throws ConfigException
    {
        super(config);
    }

    public KorobochkaConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, KorobochkaConfigDefaults.INSTANCE);
    }

    public KorobochkaConfigBuilder(
        final IniConfig config,
        final KorobochkaConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public KorobochkaConfigBuilder self() {
        return this;
    }

    public ImmutableKorobochkaConfig build()
        throws ConfigException
    {
        return new ImmutableKorobochkaConfig(this);
    }
}
