package ru.yandex.search.passport.korobochka;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.config.URIConfig;
import ru.yandex.http.config.URIConfigDefaults;
import ru.yandex.http.util.server.HttpProxyConfigDefaults;

public class KorobochkaConfigDefaults
    extends HttpProxyConfigDefaults
    implements KorobochkaConfig
{
    public static final KorobochkaConfigDefaults INSTANCE =
        new KorobochkaConfigDefaults();

    protected KorobochkaConfigDefaults() {
    }

    @Override
    public int parseThreads() {
        return 1;
    }

    @Override
    public int parseQueue() {
        return 10;
    }

    @Override
    public URIConfig korobochkaPassport() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public URIConfig korobochkaAvtoRu() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public String korobochkaPassportLogin() {
        return "user";
    }

    @Override
    public String korobochkaPassportPassword() {
        return "password";
    }

    @Override
    public String korobochkaAvtoRuLogin() {
        return "user";
    }

    @Override
    public String korobochkaAvtoRuPassword() {
        return "password";
    }

    @Override
    public HttpHostConfig blackboxConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }
}
