package ru.yandex.search.passport.korobochka;

import java.util.List;
import java.util.logging.Level;

import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.ProxySession;

public interface TopicHandler {
    public void handle(final ProxySession session, final List<byte[]> bodies);

    default void failed(final ProxySession session, final Throwable t) {
        session.logger().log(
            Level.SEVERE,
            "Unhandled error",
            t);
        session.response(HttpStatus.SC_SERVICE_UNAVAILABLE);
    }
}
