package ru.yandex.search.passport.korobochka.common;

import java.util.logging.Logger;

import ru.yandex.tskv.TskvRecord;

public abstract class AbstractLogRecord extends TskvRecord {
    private boolean skipRecord = false;

    protected AbstractLogRecord() {
        super();
    }

    public abstract void init(final Logger logger);

    public boolean skipRecord() {
        return skipRecord;
    }

    public void skipRecord(final boolean skipRecord) {
        this.skipRecord = skipRecord;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public boolean containsInKeys(
        final String needle,
        final String... fields)
    {
        for (String field: fields) {
            final String value = get(field);
            if (value != null) {
                if (value.contains(needle)) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean containsValues(
        final String key,
        final String... values)
    {
        final String value = get(key);
        if (value != null) {
            for (String needle: values) {
                if (needle.equals(value)) {
                    return true;
                }
            }
        }
        return false;
    }
}
