package ru.yandex.search.passport.korobochka.common;

import java.util.logging.Logger;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.ProxySession;

public interface LogHandler<T extends AbstractLogRecord> {
    public T createRecord();

    public void processRecord(
        final T record,
        final ProxySession session,
        final FutureCallback<T> callback);

    public void filterRecord(final T record);

    public void processRecords(final long count);

    public boolean nonTskv();

    public T parseRecord(final Logger logger, final String line);
}
