package ru.yandex.search.passport.korobochka.common;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

import ru.yandex.logger.PrefixedLogger;
import ru.yandex.tskv.TskvException;
import ru.yandex.tskv.TskvHandler;

public class TskvRecordHandler<T extends AbstractLogRecord>
    implements TskvHandler<T>
{
    private final LogHandler<T> handler;
    private final List<T> filteredRecords;
    private PrefixedLogger logger;

    TskvRecordHandler(final LogHandler<T> handler) {
        this.handler = handler;
        this.filteredRecords = new ArrayList<>();
    }

    @Override
    public boolean onRecord(final T record) {
        handler.processRecords(1L);
        logger.finest("DUMP: " + record);
        record.init(logger);
        if (record.skipRecord()) {
            logger.fine("Skipping record: " + record);
            return true;
        }
        handler.filterRecord(record);
        if (!record.skipRecord()) {
            filteredRecords.add(record);
        } else {
            logger.fine("Skipping record: " + record);
        }
        return true;
    }

    public void clear() {
        filteredRecords.clear();
    }

    public void logger(final PrefixedLogger logger) {
        this.logger = logger;
    }

    public List<T> filteredRecords() {
        return new ArrayList<>(filteredRecords);
    }

    @Override
    public boolean onError(final TskvException exc) {
        logger.log(
            Level.SEVERE,
            "TskvParse error",
            exc);
        return true;
    }

    public void close() {
    }
}
