package ru.yandex.search.passport.korobochka.passport;

import java.util.logging.Logger;

import ru.yandex.search.passport.korobochka.common.AbstractLogRecord;

public class AbstractUidRecord extends AbstractLogRecord {
    private long uid;

    public AbstractUidRecord() {
        super();
    }

    @Override
    public void init(final Logger logger) {
        try {
            uid = Long.parseLong(getOrDefault("uid", ""));
        } catch (NumberFormatException e) {
            logger.severe("Can't parser uid from record: " + this);
            skipRecord(true);
        }
    }

    public long uid() {
        return uid;
    }

    public void uid(final long uid) {
        this.uid = uid;
    }
}
