package ru.yandex.search.passport.korobochka.passport;

import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.blackbox.BlackboxAddress;
import ru.yandex.blackbox.BlackboxClient;
import ru.yandex.blackbox.BlackboxEmailsType;
import ru.yandex.blackbox.BlackboxPhoneAttributeType;
import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.blackbox.BlackboxUserinfoRequest;
import ru.yandex.blackbox.BlackboxUserinfos;
import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.search.passport.korobochka.Korobochka;
import ru.yandex.search.passport.korobochka.common.AbstractLogHandler;

public class AccountModificationHandler
    extends AbstractLogHandler<AccountModificationRecord>
{
    public static final String ENTITY = "entity";
    public static final String PHONES_SECURE = "phones.secure";
    public static final String ACCOUNT_EMAILS = "account.emails";

    private static final String[] ALLOWED_ENTITIES = {
        ACCOUNT_EMAILS,
        "account.mail_status",
        "aliases",
        "person.birthday",
        "person.firstname",
        "person.lastname",
        "person.language",
        "person.country",
        "person.gender",
        "person.fullname",
        PHONES_SECURE,
        "account.global_logout_datetime",
        "account.disabled_status"
    };

    public AccountModificationHandler(final Korobochka korobochka) {
        super(korobochka, korobochka.passportSender(), "passport");
    }

    @Override
    public AccountModificationRecord createRecord() {
        return new AccountModificationRecord();
    }

    @Override
    public void filterRecord(final AccountModificationRecord record) {
        if (record.containsValues(ENTITY, ALLOWED_ENTITIES)) {
            record.needPhone(record.containsValues(ENTITY, PHONES_SECURE));
            record.needEmail(record.containsValues(ENTITY, ACCOUNT_EMAILS));
        } else {
            record.skipRecord(true);
        }
    }

    @Override
    public void processRecord(
        final AccountModificationRecord record,
        final ProxySession session,
        final FutureCallback<AccountModificationRecord> callback)
    {
        getBBInfo(record, session, callback);
    }

    protected void bbResponse(
        final AccountModificationRecord record,
        final ProxySession session,
        final FutureCallback<AccountModificationRecord> callback)
    {
        if (record.needPhone()) {
            replacePhoneFromBB(session, record);
        } else if (record.needEmail()) {
            replaceEmailFromBB(session, record);
        }
        callback.completed(record);
    }

    private boolean maskedStringEquals(final String p1, final String p2) {
        if (p1 == null || p2 == null) {
            return false;
        }
        if (p1.length() != p2.length()) {
            return false;
        }
        for (int i = 0, len = p1.length(); i < len; i++) {
            char c1 = p1.charAt(i);
            char c2 = p2.charAt(i);
            if (
                (c1 == c2)
                || (c1 == '*')
                || (c2 == '*'))
            {
                continue;
            } else {
                return false;
            }
        }
        return true;
    }

    private void replacePhoneFromBB(
        final ProxySession session,
        final AccountModificationRecord record)
    {
        if (!record.needBBInfo() || record.bbInfo() == null) {
            return;
        }
        if (record.getOrDefault("operation", "").equals("deleted")) {
            return;
        }
        String entity = record.getOrDefault(ENTITY, "");
        String maskedPhone = record.get("new");
        int hash = record.hashCode();
        session.logger().info(hash + ": PROCESSING: " + record);
        session.logger().info(hash + ": maskedPhone: " + maskedPhone);
        if (entity.equals(PHONES_SECURE) && maskedPhone != null) {
            String newPhone = null;
            for (Map.Entry<String, Map<BlackboxPhoneAttributeType, String>> entry:
                record.bbInfo().phoneAttributes().entrySet())
            {
                Map<BlackboxPhoneAttributeType, String> phoneAttrs =
                    entry.getValue();
                newPhone = phoneAttrs.get(BlackboxPhoneAttributeType.PHONE_E164_NUMBER);
                session.logger().info(hash + ": bb.newPhone: " + newPhone);
                session.logger().info(hash + ": bb.secured: " + phoneAttrs.get(BlackboxPhoneAttributeType.IS_SECURED));
                session.logger().info(hash + ": bb.maskedPhone: " + phoneAttrs.get(BlackboxPhoneAttributeType.PHONE_MASKED_E164_NUMBER));
                if (newPhone != null
                    && phoneAttrs.get(BlackboxPhoneAttributeType.IS_SECURED) != null
                    && maskedStringEquals(
                        phoneAttrs.get(BlackboxPhoneAttributeType.PHONE_MASKED_E164_NUMBER),
                        maskedPhone))
                {
                    break;
                } else {
                    newPhone = null;
                }
            }
            if (newPhone != null) {
                record.put("new", newPhone);
                session.logger().warning(hash + ": Replaced masked phone number: "
                    + maskedPhone + " with real: " + newPhone);
            } else {
                session.logger().severe(hash + ": Can't find coresponding to masked "
                    + "phone real phone number in BB answer");
                record.skipRecord(true);
            }
        }
    }

    private void replaceEmailFromBB(
        final ProxySession session,
        final AccountModificationRecord record)
    {
        if (!record.needBBInfo() || record.bbInfo() == null) {
            return;
        }
        if (record.getOrDefault("operation", "").equals("deleted")) {
            return;
        }
        String entity = record.getOrDefault(ENTITY, "");
        String maskedEmail = record.get("new");
        int hash = record.hashCode();
        session.logger().info(hash + ": PROCESSING: " + record);
        session.logger().info(hash + ": maskedEmail: " + maskedEmail);
        if (entity.equals(ACCOUNT_EMAILS) && maskedEmail != null) {
            String newEmail = null;
            for (BlackboxAddress address: record.bbInfo().addressList()) {
                if (address == null || address.email().isEmpty()) {
                    continue;
                }
                session.logger().info(hash + ": bb.newEmail: " + address);
                if (maskedStringEquals(address.email(), maskedEmail)) {
                    newEmail = address.email();
                    break;
                } else {
                    newEmail = null;
                }
            }
            if (newEmail != null) {
                record.put("new", newEmail);
                session.logger().warning(hash + ": Replaced masked email: "
                    + maskedEmail + " with real: " + newEmail);
            } else {
                session.logger().severe(hash + ": Can't find coresponding to masked "
                    + "email real email in BB answer");
                record.skipRecord(true);
            }
        }
    }

    @SuppressWarnings("FutureReturnValueIgnored")
    private void getBBInfo(
        final AccountModificationRecord record,
        final ProxySession session,
        final FutureCallback<AccountModificationRecord> callback)
    {
        if (record.needBBInfo()) {
            ///
            BlackboxClient client =
                korobochka.blackboxClient().adjust(session.context());
            client.userinfo(
                new BlackboxUserinfoRequest(record.uid())
                    .phoneAttributes(
                        BlackboxPhoneAttributeType.PHONE_E164_NUMBER,
                        BlackboxPhoneAttributeType.PHONE_MASKED_E164_NUMBER,
                        BlackboxPhoneAttributeType.IS_BOUND,
                        BlackboxPhoneAttributeType.IS_SECURED)
                    .emailsType(BlackboxEmailsType.GETALL),
                session.listener().createContextGeneratorFor(client),
                new BlackboxCallback(session, record, callback));
        } else {
            callback.completed(record);
        }
    }

    private class BlackboxCallback extends AbstractProxySessionCallback<BlackboxUserinfos> {
        private final AccountModificationRecord record;
        private final FutureCallback<AccountModificationRecord> callback;

        BlackboxCallback(
            final ProxySession session,
            final AccountModificationRecord record,
            final FutureCallback<AccountModificationRecord> callback)
        {
            super(session);
            this.record = record;
            this.callback = callback;
        }

        @Override
        public void completed(final BlackboxUserinfos bbInfos) {
            for (BlackboxUserinfo bbInfo: bbInfos) {
                if (bbInfo.uid() == record.uid()) {
                    record.bbInfo(bbInfo);
                    break;
                }
            }
            if (record.bbInfo() == null) {
                session.logger().severe(
                    "Can't find userinfo in BB answer for uid: "
                        + record.uid());
            }
            bbResponse(record, session, callback);
        }

        @Override
        public void failed(final Exception e) {
            if (e instanceof ru.yandex.blackbox.BlackboxNotFoundException) {
                session.logger().severe(
                    "BB user not found for uid/record: " + record.uid()
                        + "/" + record);
                record.skipRecord(true);
                callback.completed(record);
            } else {
                super.failed(e);
            }
        }
    }

}
