#!/bin/bash
set -exo pipefail

source config.sh

source zk_classpath.sh

source recommended_java_args.sh


#export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["slot.memory_limit"]' | gawk '{print int($1*0.8)}')
#export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk '{print int($1)}')
GB=$((1024*1024*1024))
GB1_5=$((GB + (GB/2)))
MEMORY_GAP=${MEMORY_GAP:-$GB1_5}
XMX=$((GB))

# https://www.oracle.com/technical-resources/articles/java/g1gc.html advises 5/8 in that case
# i don't get why, may be it apply only in nocontainer enviroment due to hyperthreading thing
PARALLEL_GCS=${PARALLEL_GCS:-$CPU_CORES}
CONC_GC_THREADS=${CONC_GC_THREADS:-1}
GC_ARGS="
-XX:+DisableExplicitGC
-Xlog:gc*:/dev/shm/gclogs/gc.log
-XX:+UnlockExperimentalVMOptions
-XX:+UseG1GC
-Xmx$XMX
-Xms$XMX
-Xmn512M
-XX:ParallelGCThreads=$PARALLEL_GCS
-XX:ConcGCThreads=$CONC_GC_THREADS
-XX:G1ConcRefinementThreads=1
-XX:MaxGCPauseMillis=50
-XX:G1MixedGCCountTarget=32
-XX:G1HeapWastePercent=20
-XX:G1AdaptiveIHOPNumInitialSamples=10
-XX:+PrintGCDetails
"

exec $BSCONFIG_IDIR/jdk/bin/java \
    $GC_ARGS $NET_ARGS \
    -DBSCONFIG_IPORT=$BSCONFIG_IPORT \
    -Djava.library.path=. \
    -Djava.library.path=./dispatcher_zk_service/ \
    -cp $CLASSPATH \
    ru.yandex.dispatcher.producer.Producer ./producer.conf

