#!/bin/bash
set -exo pipefail

export REPLICA_NAME=$(jq .leader.dynamicProperties.GENCFG_GROUP metainstance.json|tr -d '"'|tr 'A-Z_' 'a-z-')
export MTN_TAG=$(hostname -s)

export LOG_DIR="/logs"
export DATA_DIR="/ssd/senders/index"
export INDEX_DIR="$DATA_DIR/project"
export CORE_DIR="/coredumps"

export LOGROTATE_DAYS=1

export PROXY_PORT=${BSCONFIG_IPORT:-80}
export LUCENE_PORT=${BSCONFIG_IPORT_PLUS_1:-81}
export LUCENE_SEARCHER_PORT=${BSCONFIG_IPORT_PLUS_2:-82}
export LUCENE_INDEXER_PORT=${BSCONFIG_IPORT_PLUS_3:-83}
export LUCENE_DUMP_PORT=${BSCONFIG_IPORT_PLUS_4:-84}
export PRODUCER_PORT=${BSCONFIG_IPORT_PLUS_8:-88}
export CONSUMER_PORT=${BSCONFIG_IPORT_PLUS_9:-89}

case "$NANNY_SERVICE_ID" in
    *)
        ;;
esac

