#!/bin/sh

GB=$((1024*1024*1024))
GB2=$((GB + GB))
XMX=$(portoctl get self memory_limit_total)
XMX=$((XMX-GB2))

mkdir -p /webcache/javasharedresources/512m >/dev/null 2>&1
export GC_ARGS_IBM="-XX:ActiveProcessorCount=3 \
-XX:+IgnoreUnrecognizedVMOptions \
-XcompilationThreads1 \
-Xgc:concurrentScavengeBackground=1 \
-Xgc:concurrentScavenge \
-XX:IdleTuningGcOnIdle \
-XX:IdleTuningMinIdleWaitTime=1 \
-Xgc:maxScavengeBeforeGlobal=100 \
-Xcodecache8M \
-Xcodecachetotal64M \
-Xmso128K \
-Xmcrs64M \
-Xmx$XMX \
-Xms$XMX \
-Xmn512M \
-Xgcthreads2 \
-Xconcurrentbackground1 \
-Xgc:concurrentMark \
-Xaggressive \
-Xsoftrefthreshold1000000000 \
-Xjit:scratchSpaceLimit=$((64*1024)) \
-Djdk.nio.maxCachedBufferSize=$((256*1024)) \
-verbose:gc \
-Xverbosegclog:/dev/shm/gc.log,10,10000 \
-Xtune:virtualized"

export GC_ARGS="
-XX:ActiveProcessorCount=8
-XX:+IgnoreUnrecognizedVMOptions
-Xmx$XMX
-Xms$XMX
-XX:+PrintGC
-XX:+PrintGCDetails
-XX:+UnlockExperimentalVMOptions
-verbose:gc
-XX:+UseG1GC
-XX:ConcGCThreads=2
-XX:ParallelGCThreads=6
-XX:+UnlockDiagnosticVMOptions
-XX:+PrintGCDateStamps
-XX:+UseGCLogFileRotation -XX:NumberOfGCLogFiles=5 -XX:GCLogFileSize=2M
-XX:MaxGCPauseMillis=15
-XX:G1MixedGCCountTarget=32
-XX:G1HeapWastePercent=20
-XX:G1AdaptiveIHOPNumInitialSamples=10
-Xloggc:/dev/shm/gc.log"
