package ru.yandex.dbfields;

public enum ChangeType {
    STORE,
    UPDATE,
    MOVE,
    DELETE,
    COPY,
    THREADS_JOIN,

    LABEL_CREATE,
    LABEL_DELETE,
    LABEL_MODIFY,

    FOLDER_CREATE,
    FOLDER_DELETE,
    FOLDER_MODIFY,

    FRESH_RESET,
    TRANSFER,
    UPDATE_ATTACH,
    FOLDER_MODIFY_TYPE,
    QUICK_SAVE,
    REINDEX,
    FOLDER_RESET_UNVISITED,

    IMAP_ADD_UNSUBSCRIBED,
    IMAP_DELETE_UNSUBSCRIBED,

    POP3_FOLDERS_ENABLE,
    POP3_FOLDERS_DISABLE,
    POP3_FOLDER_INITIALIZATION,
    POP3_DELETE,

    REGISTER,

    SHARED_FOLDER_CREATE,
    SHARED_FOLDER_DELETE,
    SHARED_FOLDER_SUBSCRIBE,
    SHARED_FOLDER_UNSUBSCRIBE,
    SUBSCRIBED_FOLDER_CREATE,
    SUBSCRIBED_FOLDER_DELETE,
    SYNC_STORE,
    SYNC_UPDATE,
    SYNC_DELETE,
    SYNC_THREADS_JOIN,

    USER_DELETE,
    // https://st.yandex-team.ru/MAILPG-3544
    USER_STATE_UPDATE,

    // mid moved from mulca to MDS
    MESSAGE_STORAGE_CHANGE,

    // just ignore it: https://st.yandex-team.ru/PS-3730
    STORE_DELETED,
    // message archivation rules
    SET_ARCHIVATION_RULE,
    REMOVE_ARCHIVATION_RULE,

    CREATE_CONTACTS_USER,

    SEARCH_UPDATE,
    SEARCH_MIDS_CLEANUP,
    // PS-3239 tabs actions
    TAB_CREATE,
    TAB_RESET_UNVISITED,
    MOVE_TO_TAB,

    // collectors actions
    COLLECTOR_CREATE,
    COLLECTOR_DELETE,
    COLLECTOR_UPDATE,

    // use this change_type for document field update
    // we can not use lucene update due to not stored fields
    FIELDS_UPDATE,
    USER_TYPE_UPDATE,

    IEX_UPDATE,

    STICKER_CREATE,
    STICKER_REMOVE,
}

