package ru.yandex.dbfields;

public enum DBFieldType {
    JSON {
        @Override
        public <T> T createProcessor(
            final FieldProcessorFactory<T> processorFactory,
            final String outFieldName)
        {
            return processorFactory.createJsonProcessor(outFieldName);
        }
    },
    STRING {
        @Override
        public <T> T createProcessor(
            final FieldProcessorFactory<T> processorFactory,
            final String outFieldName)
        {
            return processorFactory.createStringProcessor(outFieldName);
        }
    },
    TIMESTAMP {
        @Override
        public <T> T createProcessor(
            final FieldProcessorFactory<T> processorFactory,
            final String outFieldName)
        {
            return processorFactory.createTimestampProcessor(outFieldName);
        }
    };

    public abstract <T> T createProcessor(
        final FieldProcessorFactory<T> processorFactory,
        final String outFieldName);
}

