package ru.yandex.dbfields;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum DBFieldsRegistry {
    INSTANCE;

    @SuppressWarnings("ImmutableEnumChecker")
    private final Map<String, DBFieldInfo> map;

    DBFieldsRegistry() {
        DBFieldInfo[] knownFields = new DBFieldInfo[] {
            new BasicDBFieldInfo(PgFields.MID, DBFieldType.STRING),
            new BasicDBFieldInfo(
                OracleFields.OPERATION_ID,
                DBFieldType.STRING),
            new BasicDBFieldInfo(OracleFields.LCN, DBFieldType.STRING),
            new BasicDBFieldInfo(
                OracleFields.OPERATION_DATE,
                DBFieldType.TIMESTAMP),
            new BasicDBFieldInfo(OracleFields.FRESH_COUNT, DBFieldType.STRING),
            new BasicDBFieldInfo(
                OracleFields.USEFUL_NEW_MESSAGES,
                DBFieldType.STRING),
            new BasicDBFieldInfo(PgFields.CHANGE_TYPE, DBFieldType.STRING),
            new BasicDBFieldInfo(PgFields.UID, DBFieldType.STRING),
            new BasicDBFieldInfo(PgFields.CHANGED, DBFieldType.JSON),
            new BasicDBFieldInfo(PgFields.ARGUMENTS, DBFieldType.JSON),
            new BasicDBFieldInfo(PgFields.DB_USER, DBFieldType.STRING),
            new BasicDBFieldInfo(PgFields.SESSION_KEY, DBFieldType.STRING),
            // collie / aceventura
            new BasicDBFieldInfo(CollieFields.USER_ID, DBFieldType.STRING),
            new BasicDBFieldInfo(CollieFields.USER_TYPE, DBFieldType.STRING),
            new BasicDBFieldInfo(CollieFields.REVISION, DBFieldType.STRING),
        };

        map = new HashMap<>(knownFields.length << 2);
        for (DBFieldInfo fieldInfo: knownFields) {
            map.put(fieldInfo.fieldName(), fieldInfo);
            map.put(fieldInfo.fieldName().toUpperCase(Locale.ROOT), fieldInfo);
        }
    }

    public DBFieldInfo get(final String fieldName) {
        return map.get(fieldName);
    }
}

