package ru.yandex.search.mail.kamaji;

import org.apache.http.concurrent.FutureCallback;

public abstract class AbstractCallback<T> implements FutureCallback<T> {
    protected final KamajiIndexationContext context;
    protected final FutureCallback<Object> callback;

    protected AbstractCallback(
        final KamajiIndexationContext context,
        final FutureCallback<Object> callback)
    {
        this.context = context;
        this.callback = callback;
    }

    public KamajiIndexationContext context() {
        return context;
    }

    public FutureCallback<Object> callback() {
        return callback;
    }

    @Override
    public void cancelled() {
        callback.cancelled();
    }

    @Override
    public void failed(final Exception e) {
        callback.failed(e);
    }
}

