package ru.yandex.search.mail.kamaji;

import java.util.logging.Level;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.HttpExceptionConverter;
import ru.yandex.http.util.YandexHttpStatus;

public abstract class AbstractIndexCallback implements FutureCallback<Object> {
    protected final ChangeContext context;

    protected AbstractIndexCallback(final ChangeContext context) {
        this.context = context;
    }

    public ChangeContext context() {
        return context;
    }

    @Override
    public void cancelled() {
        context.session().logger().warning(
            "Request cancelled: " + context.session().listener().details());
        context.session().response(YandexHttpStatus.SC_CLIENT_CLOSED_REQUEST);
    }

    @Override
    public void failed(final Exception e) {
        context.session().logger().log(
            Level.WARNING,
            "Failed to process: " + context.humanReadableJson()
            + '\n' + context.session().listener().details()
            + " because of exception",
            e);
        context.session().handleException(
            HttpExceptionConverter.toHttpException(e));
    }

    protected void logLag() {
        context.session().logger().info(
            "PG processing lag: "
            + (System.currentTimeMillis() - context.operationDateMillis())
            + " ms");
    }
}

