package ru.yandex.search.mail.kamaji;

import java.util.List;

import org.apache.http.HttpStatus;

import ru.yandex.dbfields.PgFields;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public class BasicIndexCallback extends AbstractIndexCallback {
    protected final List<?> changed;

    public BasicIndexCallback(final ChangeContext context)
        throws JsonUnexpectedTokenException
    {
        super(context);
        changed = ValueUtils.asList(context.json().get(PgFields.CHANGED));
    }

    public List<?> changed() {
        return changed;
    }

    @Override
    public void completed(final Object result) {
        logLag();
        context.session().response(HttpStatus.SC_OK);
    }
}

