package ru.yandex.search.mail.kamaji;

import org.apache.http.HttpStatus;

import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.search.mail.kamaji.senders.AbstractSendersIndexerModule;

public class DeleteUserPgHandler implements ChangeHandler {
    @Override
    public void handle(final ChangeContext context) {
        StringBuilder sb = new StringBuilder("/delete?prefix=");
        String prefix = Long.toString(context.prefix());
        sb.append(prefix);
        sb.append("&text=uid:");
        sb.append(prefix);
        sb.append("+OR+fact_uid:");
        sb.append(prefix);
        sb.append("+OR+__prefix:");
        sb.append(prefix);
        for (String field: AbstractSendersIndexerModule.UID_FIELDS) {
            sb.append("+OR+");
            sb.append(field);
            sb.append(':');
            sb.append(prefix);
        }
        AsyncClient client = context.kamaji().backendClient()
            .adjustZooHeaders(context.session().context())
            .addHeader(
                YandexHeaders.X_INDEX_OPERATION_TIMESTAMP,
                Long.toString(context.operationDateMillis()));
        client.execute(
            context.kamaji().backendHost(),
            new BasicAsyncRequestProducerGenerator(new String(sb)),
            EmptyAsyncConsumerFactory.ANY_GOOD,
            context.session().listener().createContextGeneratorFor(client),
            new Callback(context));
    }

    private static class Callback extends AbstractIndexCallback {
        Callback(final ChangeContext context) {
            super(context);
        }

        @Override
        public void completed(final Object result) {
            logLag();
            context.session().response(HttpStatus.SC_OK);
        }
    }
}

