package ru.yandex.search.mail.kamaji;

import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;

import ru.yandex.client.tvm2.ImmutableTvm2ClientConfig;
import ru.yandex.http.config.ImmutableFilterSearchConfig;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.mail.kamaji.usertype.ImmutableUserTypeConfig;
import ru.yandex.search.mail.kamaji.usertype.UserTypeConfig;

public class ImmutableKamajiConfig
    extends ImmutableHttpProxyConfig
    implements KamajiConfig
{
    private final ImmutableHttpHostConfig backendConfig;
    private final ImmutableHttpHostConfig searchConfig;
    private final ImmutableHttpHostConfig slowIndexerConfig;
    private final ImmutableHttpHostConfig blackboxConfig;
    private final ImmutableHttpHostConfig tikaiteConfig;
    private final ImmutableTvm2ClientConfig tvm2ClientConfig;
    private final String tikaiteTvmClientId;
    private final String unistorageTvmClientId;
    private final String blackboxTvmClientId;
    private final String filterSearchTvmClientId;
    private final ImmutableFilterSearchConfig filterSearchConfig;
    private final ImmutableUserTypeConfig userTypeConfig;
    private final Pattern mdbs;
    private final Set<String> preserveFields;
    private final boolean subscriptionsIndexEnabled;
    private final long tikaiteMemoryLimit;
    private final int tikaiteMemoryQueueCapacity;

    public ImmutableKamajiConfig(final KamajiConfig config)
        throws ConfigException
    {
        super(config);
        forceTvm2ServiceConfig();

        backendConfig = new ImmutableHttpHostConfig(config.backendConfig());
        searchConfig = new ImmutableHttpHostConfig(config.searchConfig());
        slowIndexerConfig =
            new ImmutableHttpHostConfig(config.slowIndexerConfig());
        blackboxConfig = new ImmutableHttpHostConfig(config.blackboxConfig());
        tikaiteConfig = new ImmutableHttpHostConfig(config.tikaiteConfig());
        tvm2ClientConfig =
            new ImmutableTvm2ClientConfig(config.tvm2ClientConfig());
        tikaiteTvmClientId = config.tikaiteTvmClientId();
        unistorageTvmClientId = config.unistorageTvmClientId();
        blackboxTvmClientId = config.blackboxTvmClientId();
        filterSearchTvmClientId = config.filterSearchTvmClientId();
        filterSearchConfig =
            new ImmutableFilterSearchConfig(config.filterSearchConfig());
        userTypeConfig = new ImmutableUserTypeConfig(config.userTypeConfig());
        mdbs = config.mdbs();
        preserveFields = Collections.unmodifiableSet(config.preserveFields());
        subscriptionsIndexEnabled = config.subscriptionsIndexEnabled();
        tikaiteMemoryLimit = config.tikaiteMemoryLimit();
        tikaiteMemoryQueueCapacity = config.tikaiteMemoryQueueCapacity();
    }

    @Override
    public ImmutableHttpHostConfig backendConfig() {
        return backendConfig;
    }

    @Override
    public ImmutableHttpHostConfig searchConfig() {
        return searchConfig;
    }

    @Override
    public ImmutableHttpHostConfig slowIndexerConfig() {
        return slowIndexerConfig;
    }

    @Override
    public ImmutableHttpHostConfig blackboxConfig() {
        return blackboxConfig;
    }

    @Override
    public ImmutableHttpHostConfig tikaiteConfig() {
        return tikaiteConfig;
    }

    @Override
    public ImmutableTvm2ClientConfig tvm2ClientConfig() {
        return tvm2ClientConfig;
    }

    @Override
    public String tikaiteTvmClientId() {
        return tikaiteTvmClientId;
    }

    @Override
    public String unistorageTvmClientId() {
        return unistorageTvmClientId;
    }

    @Override
    public String blackboxTvmClientId() {
        return blackboxTvmClientId;
    }

    @Override
    public String filterSearchTvmClientId() {
        return filterSearchTvmClientId;
    }

    @Override
    public ImmutableFilterSearchConfig filterSearchConfig() {
        return filterSearchConfig;
    }

    @Override
    public UserTypeConfig userTypeConfig() {
        return userTypeConfig;
    }

    @Override
    public Pattern mdbs() {
        return mdbs;
    }

    @Override
    public Set<String> preserveFields() {
        return preserveFields;
    }

    @Override
    public boolean subscriptionsIndexEnabled() {
        return subscriptionsIndexEnabled;
    }

    @Override
    public long tikaiteMemoryLimit() {
        return tikaiteMemoryLimit;
    }

    @Override
    public int tikaiteMemoryQueueCapacity() {
        return tikaiteMemoryQueueCapacity;
    }
}

