package ru.yandex.search.mail.kamaji;

import java.util.Set;
import java.util.regex.Pattern;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.http.config.FilterSearchConfig;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.util.server.HttpProxyConfig;
import ru.yandex.search.mail.kamaji.usertype.UserTypeConfig;

public interface KamajiConfig extends HttpProxyConfig {
    HttpHostConfig backendConfig();

    HttpHostConfig searchConfig();

    HttpHostConfig slowIndexerConfig();

    HttpHostConfig blackboxConfig();

    HttpHostConfig tikaiteConfig();

    Tvm2ClientConfig tvm2ClientConfig();

    String tikaiteTvmClientId();

    String unistorageTvmClientId();

    String blackboxTvmClientId();

    String filterSearchTvmClientId();

    FilterSearchConfig filterSearchConfig();

    UserTypeConfig userTypeConfig();

    Set<String> preserveFields();

    Pattern mdbs();

    boolean subscriptionsIndexEnabled();

    long tikaiteMemoryLimit();

    int tikaiteMemoryQueueCapacity();
}

