package ru.yandex.search.mail.kamaji;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class KamajiConfigBuilder
    extends AbstractKamajiConfigBuilder<KamajiConfigBuilder>
{
    public KamajiConfigBuilder() {
        super(KamajiConfigDefaults.INSTANCE);
    }

    public KamajiConfigBuilder(final KamajiConfig config) {
        super(config);
    }

    public KamajiConfigBuilder(final IniConfig config) throws ConfigException {
        super(config, KamajiConfigDefaults.INSTANCE);
    }

    public KamajiConfigBuilder(
        final IniConfig config,
        final KamajiConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public KamajiConfigBuilder self() {
        return this;
    }

    public ImmutableKamajiConfig build() throws ConfigException {
        return new ImmutableKamajiConfig(this);
    }
}

