package ru.yandex.search.mail.kamaji;

import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;

import ru.yandex.client.tvm2.Tvm2ClientConfigDefaults;
import ru.yandex.http.config.FilterSearchConfigDefaults;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.util.server.HttpProxyConfigDefaults;
import ru.yandex.search.mail.kamaji.usertype.UserTypeConfig;
import ru.yandex.search.mail.kamaji.usertype.UserTypeConfigDefaults;

public class KamajiConfigDefaults
    extends HttpProxyConfigDefaults
    implements KamajiConfig
{
    public static final KamajiConfigDefaults INSTANCE =
        new KamajiConfigDefaults();

    protected KamajiConfigDefaults() {
    }

    @Override
    public String name() {
        return "Kamaji";
    }

    @Override
    public HttpHostConfigDefaults backendConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults searchConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults slowIndexerConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults blackboxConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults tikaiteConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public Tvm2ClientConfigDefaults tvm2ClientConfig() {
        return Tvm2ClientConfigDefaults.INSTANCE;
    }

    @Override
    public String tikaiteTvmClientId() {
        return null;
    }

    @Override
    public String unistorageTvmClientId() {
        return null;
    }

    @Override
    public String blackboxTvmClientId() {
        return null;
    }

    @Override
    public String filterSearchTvmClientId() {
        return null;
    }

    @Override
    public FilterSearchConfigDefaults filterSearchConfig() {
        return FilterSearchConfigDefaults.INSTANCE;
    }

    @Override
    public UserTypeConfig userTypeConfig() {
        return UserTypeConfigDefaults.INSTANCE;
    }

    @Override
    public Pattern mdbs() {
        return Pattern.compile(".*");
    }

    @Override
    public Set<String> preserveFields() {
        return Collections.emptySet();
    }

    @Override
    public boolean subscriptionsIndexEnabled() {
        return false;
    }

    @Override
    public long tikaiteMemoryLimit() {
        return -1L;
    }

    @Override
    public int tikaiteMemoryQueueCapacity() {
        return 500;
    }
}

