package ru.yandex.search.mail.kamaji;

import org.apache.http.HttpRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.server.async.PingHandler;

public class KamajiPingHandler extends PingHandler {
    private final Kamaji kamaji;

    public KamajiPingHandler(final Kamaji kamaji) {
        super(kamaji);
        this.kamaji = kamaji;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
    {
        if (!kamaji.updatePosition(
            request,
            context,
            new QueuePingFutureCallback(request, exchange, context)))
        {
            super.handle(request, exchange, context);
        }
    }

    private final class QueuePingFutureCallback
        implements FutureCallback<Object>
    {
        private final HttpRequest request;
        private final HttpAsyncExchange exchange;
        private final HttpContext context;

        private QueuePingFutureCallback(
            final HttpRequest request,
            final HttpAsyncExchange exchange,
            final HttpContext context)
        {
            this.request = request;
            this.exchange = exchange;
            this.context = context;
        }

        @Override
        public void completed(final Object o) {
            KamajiPingHandler.super.handle(request, exchange, context);
        }

        @Override
        public void failed(final Exception e) {
            exchange.submitResponse(kamaji.handleException(e, context));
        }

        @Override
        public void cancelled() {
        }
    }
}
