package ru.yandex.search.mail.kamaji;

import java.util.List;

import org.apache.http.HttpException;

import ru.yandex.dbfields.PgFields;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public enum MidsCleanupHandler implements ChangeHandler {
    INSTANCE;

    @Override
    public void handle(final ChangeContext context)
        throws HttpException, JsonUnexpectedTokenException
    {
        BasicIndexCallback callback = new BasicIndexCallback(context);
        List<?> changed = callback.changed();
        if (changed.size() != 2) {
            throw new BadRequestException(
                "Expected exactly two mids in 'changed' list: "
                + context.json());
        }
        long firstMid = ValueUtils.asLong(
            ValueUtils.asMap(changed.get(0)).get(PgFields.MID));
        long lastMid = ValueUtils.asLong(
            ValueUtils.asMap(changed.get(1)).get(PgFields.MID));
        AsyncClient client = context.kamaji().backendClient()
            .adjustZooHeaders(context.session().context());
        client.execute(
            context.kamaji().backendHost(),
            new BasicAsyncRequestProducerGenerator(
                "/delete?prefix=" + context.prefix()
                + "&text=((mid_padded:[0+TO+" + (firstMid - 1)
                + "]+OR+mid_padded:[" + (lastMid + 1)
                + "+TO+99999999999999999999])+AND+lcn:[0+TO+" + context.lcn()
                + "])+OR+(uid:" + context.prefix()
                + "+AND+NOT+mid_padded:*)"),
            EmptyAsyncConsumerFactory.ANY_GOOD,
            context.session().listener().createContextGeneratorFor(client),
            callback);
    }
}

