package ru.yandex.search.mail.kamaji;

import org.apache.http.HttpStatus;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.HttpExceptionConverter;

public class UnknownChangeHandler implements ChangeHandler {
    public static final UnknownChangeHandler INSTANCE =
        new UnknownChangeHandler();

    protected UnknownChangeHandler() {
    }

    @Override
    public void handle(final ChangeContext context) {
        context.session().logger().warning(
            "No handler found for the following change: " + context.json());

        if (context.kamaji().updatePosition(
            context.session().request(),
            context.session().context(),
            new PositionUpdateCallback(context)))
        {
            return;
        }

        context.session().logger().info(
            "Failed to update position, missing headers?");

        context.session().response(HttpStatus.SC_OK);
    }

    private static final class PositionUpdateCallback
        implements FutureCallback<Object>
    {
        private final ChangeContext context;

        private PositionUpdateCallback(final ChangeContext context) {
            this.context = context;
        }

        @Override
        public void completed(final Object o) {
            context.session().response(HttpStatus.SC_OK);
        }

        @Override
        public void failed(final Exception e) {
            context.session().handleException(
                HttpExceptionConverter.toHttpException(e));
        }

        @Override
        public void cancelled() {
        }
    }
}

