package ru.yandex.search.mail.kamaji;

import java.net.URISyntaxException;
import java.nio.charset.CharacterCodingException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.message.BasicHeader;

import ru.yandex.blackbox.BlackboxClient;
import ru.yandex.blackbox.BlackboxDbfield;
import ru.yandex.blackbox.BlackboxEmailsType;
import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.blackbox.BlackboxUserinfoRequest;
import ru.yandex.blackbox.SingleUserinfoBlackboxCallback;
import ru.yandex.client.wmi.FilterSearchErrorSuppressingFutureCallback;
import ru.yandex.client.wmi.FilterSearchResponseConsumerFactory;
import ru.yandex.dbfields.ChangeType;
import ru.yandex.dbfields.PgFields;
import ru.yandex.function.StringBuilderProcessorAdapter;
import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.DoubleFutureCallback;
import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.ServiceUnavailableException;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;
import ru.yandex.http.util.nio.HeaderAsyncRequestProducerSupplier;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.http.util.nio.client.AsyncGetURIRequestProducerSupplier;
import ru.yandex.http.util.server.UpstreamStaterFutureCallback;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;
import ru.yandex.parser.uri.PctEncoder;
import ru.yandex.parser.uri.PctEncodingRule;
import ru.yandex.search.document.mail.FirstlineMailMetaInfo;
import ru.yandex.search.mail.kamaji.update.fast.FastFilterSearchCallback;
import ru.yandex.search.mail.kamaji.update.slow.SlowFilterSearchCallback;

public enum UpdateHandler implements ChangeHandler {
    INSTANCE;

    @Override
    public void handle(final ChangeContext context)
        throws BadRequestException, JsonUnexpectedTokenException
    {
        BlackboxClient client = context.kamaji().blackboxClient()
            .adjust(context.session().context());
        client.userinfo(
            new BlackboxUserinfoRequest(context.prefixType(), context.prefix())
                .emailsType(BlackboxEmailsType.GETALL)
                .requiredDbfields(BlackboxDbfield.SUID, BlackboxDbfield.MDB)
                .addHeader(
                    YandexHeaders.X_YA_SERVICE_TICKET,
                    context.kamaji().blackboxTvm2Ticket()),
            context.session().listener().createContextGeneratorFor(client),
            new SingleUserinfoBlackboxCallback(
                new BlackboxCallback(
                    new OffsetCallback(context, true))));
    }

    // CSOFF: MethodLength
    public static void index(
        final BlackboxUserinfo userinfo,
        final OffsetCallback callback)
    {
        try {
            ChangeContext context = callback.context();
            Kamaji kamaji = context.kamaji();
            StringBuilder filterSearchUri =
                new StringBuilder(kamaji.filterSearchUri());
            filterSearchUri.append(context.prefix());
            filterSearchUri.append("&mdb=");
            filterSearchUri.append(
                userinfo.dbfields().get(BlackboxDbfield.MDB));
            filterSearchUri.append("&suid=");
            filterSearchUri.append(
                userinfo.dbfields().get(BlackboxDbfield.SUID));

            filterSearchUri.append("&lcn=");
            if (context.changeType() == ChangeType.FIELDS_UPDATE) {
                filterSearchUri.append(-1);
                filterSearchUri.append("&zoo-queue-id=");
                filterSearchUri.append(context.zooQueueId());
            } else {
                filterSearchUri.append(context.lcn());
            }

            if (context.corp()) {
                filterSearchUri.append("&folder_set=default");
            }
            Long operationId = ValueUtils.asLongOrNull(
                context.json().get(PgFields.OPERATION_ID));
            if (operationId != null) {
                filterSearchUri.append("&operation-id=");
                filterSearchUri.append(operationId.toString());
            }
            String pgshard = ValueUtils.asStringOrNull(
                context.json().get(PgFields.PGSHARD));
            if (pgshard != null) {
                filterSearchUri.append("&pgshard=");
                PctEncoder encoder = new PctEncoder(PctEncodingRule.QUERY);
                encoder.process(pgshard.toCharArray());
                encoder.processWith(
                    new StringBuilderProcessorAdapter(filterSearchUri));
            }
            for (int i = 0; i < callback.batchSize(); ++i) {
                filterSearchUri.append("&mids=");
                String mid =
                    ValueUtils.asString(
                        ValueUtils.asMap(
                            callback.changed().get(i + context.offset()))
                            .get(PgFields.MID));
                // workaround PS-2298
                try {
                    Long.parseLong(mid);
                } catch (NumberFormatException e) {
                    throw new BadRequestException("Malformed mid: " + mid, e);
                }
                filterSearchUri.append(mid);
            }
            String uri = new String(filterSearchUri);
            FutureCallback<
                Map.Entry<
                    List<FirstlineMailMetaInfo>,
                    Object>> fsCallback;
            if (context.slow()) {
                fsCallback =
                    new SlowFilterSearchCallback(callback, uri, userinfo);
            } else {
                fsCallback =
                    new FastFilterSearchCallback(callback, uri, userinfo);
            }

            DoubleFutureCallback<
                List<FirstlineMailMetaInfo>,
                Object> doubleCallback =
                    new DoubleFutureCallback<>(fsCallback);
            if (context.changeType() == ChangeType.SEARCH_UPDATE
                && !context.slow())
            {
                StringBuilder deleteUri = new StringBuilder("/delete?prefix=");
                deleteUri.append(context.prefix());
                deleteUri.append("&text=lcn:[0+TO+");
                deleteUri.append(context.lcn());
                deleteUri.append("]+AND+mid_padded:[");
                int first;
                if (context.offset() == 0) {
                    first = 0;
                } else {
                    first = -1;
                }
                deleteUri.append(
                    ValueUtils.asString(
                        ValueUtils.asMap(
                            callback.changed().get(first + context.offset()))
                            .get(PgFields.MID)));
                deleteUri.append("+TO+");
                deleteUri.append(
                    ValueUtils.asString(
                        ValueUtils.asMap(
                            callback.changed().get(
                                callback.batchSize() - 1 + context.offset()))
                            .get(PgFields.MID)));
                deleteUri.append("]+AND+NOT+mid_padded:(");
                for (int i = first; i < callback.batchSize(); ++i) {
                    if (i != first) {
                        deleteUri.append('+');
                    }
                    deleteUri.append(
                        ValueUtils.asString(
                            ValueUtils.asMap(
                                callback.changed().get(i + context.offset()))
                                .get(PgFields.MID)));
                }
                deleteUri.append(')');
                AsyncClient client = kamaji.backendClient()
                    .adjust(context.session().context());
                client.execute(
                    kamaji.backendHost(),
                    new BasicAsyncRequestProducerGenerator(
                        new String(deleteUri)),
                    EmptyAsyncConsumerFactory.OK,
                    context.session().listener()
                        .createContextGeneratorFor(client),
                    doubleCallback.second());
            } else {
                doubleCallback.second().completed(null);
            }
            AsyncClient client = kamaji.filterSearchClient();
            try {
                client.execute(
                    //new AsyncGetURIRequestProducerSupplier(uri),
                    new HeaderAsyncRequestProducerSupplier(
                        new AsyncGetURIRequestProducerSupplier(uri),
                        new BasicHeader(
                            YandexHeaders.X_YA_SERVICE_TICKET,
                            context.kamaji().filterSearchTvm2Ticket())),
                    new StatusCheckAsyncResponseConsumerFactory<>(
                        HttpStatusPredicates.OK,
                        new FilterSearchResponseConsumerFactory(
                            callback.context().prefix(),
                            Objects.toString(callback.context().lcn(), null))),
                    context.session().listener()
                        .createContextGeneratorFor(client),
                    new FilterSearchErrorSuppressingFutureCallback<>(
                        new UpstreamStaterFutureCallback<>(
                            doubleCallback.first(),
                            context.kamaji().filterSearchStater()),
                        Collections.emptyList(),
                        context.session().logger()));
            } catch (URISyntaxException e) {
                context.session().handleException(
                    new ServiceUnavailableException(e));
            }
        } catch (HttpException e) {
            callback.failed(e);
        } catch (CharacterCodingException | JsonUnexpectedTokenException e) {
            callback.failed(new BadRequestException(e));
        }
    }
    // CSON: MethodLength

    private static class BlackboxCallback
        extends AbstractFilterFutureCallback<BlackboxUserinfo, Object>
    {
        private final OffsetCallback offsetCallback;

        BlackboxCallback(final OffsetCallback offsetCallback) {
            super(offsetCallback);
            this.offsetCallback = offsetCallback;
        }

        @Override
        public void completed(final BlackboxUserinfo userinfo) {
            index(userinfo, offsetCallback);
        }
    }
}

