package ru.yandex.search.mail.kamaji.senders;

import java.util.HashSet;
import java.util.Set;

import ru.yandex.parser.email.MailAliases;

public class Address {
    private final Set<String> names = new HashSet<>(2);
    private final String normalized;

    public Address(final String email) {
        normalized = MailAliases.INSTANCE.normalizeEmail(email);
    }

    public Address(final String email, final String name) {
        normalized = MailAliases.INSTANCE.normalizeEmail(email);
        if (name != null && !name.isEmpty()) {
            names.add(name);
        }
    }

    public void merge(final Address other) {
        if (!normalized.equals(other.normalized)) {
            throw new IllegalArgumentException(
                "Can't merge different addresses");
        }
        names.addAll(other.names);
    }

    public String names() {
        if (names.isEmpty()) {
            return null;
        } else {
            StringBuilder sb = new StringBuilder();
            for (String name: names) {
                sb.append(name).append('\n');
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            return new String(sb);
        }
    }

    public String normalized() {
        return normalized;
    }

    @Override
    public String toString() {
        return normalized + ':' + names;
    }
}

