package ru.yandex.search.mail.kamaji.senders;

import java.util.AbstractCollection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Addresses extends AbstractCollection<Address> {
    private final Map<String, Address> map = new HashMap<>();

    public boolean intersects(final Addresses that) {
        return !Collections.disjoint(this.map.keySet(), that.map.keySet());
    }

    @Override
    public boolean contains(final Object o) {
        if (o instanceof Address) {
            return map.containsKey(((Address) o).normalized());
        }
        return false;
    }

    @Override
    public boolean add(final Address address) {
        String normalized = address.normalized();
        Address stored = map.get(normalized);
        if (stored != null) {
            stored.merge(address);
        } else {
            map.put(normalized, address);
        }
        return true;
    }

    @Override
    public Iterator<Address> iterator() {
        return map.values().iterator();
    }

    @Override
    public int size() {
        return map.size();
    }
}

