package ru.yandex.search.mail.kamaji.senders;

import java.util.List;
import java.util.Map;

import ru.yandex.dbfields.MailIndexFields;
import ru.yandex.parser.mail.senders.SenderInfo;
import ru.yandex.search.mail.kamaji.KamajiIndexationContext;

public class ReindexSendersIndexerModule extends AbstractSendersIndexerModule {
    public static final ReindexSendersIndexerModule INSTANCE =
        new ReindexSendersIndexerModule();

    @Override
    protected List<Map<String, Object>> indexIncoming(
        final KamajiIndexationContext context,
        final Addresses to,
        final Address from,
        final List<SenderInfo> senders)
    {
        List<Map<String, Object>> documents =
            super.indexIncoming(context, to, from, senders);

        if (context.isSpamOrTrash()) {
            context.changeContext().session().logger().info(
                "Skipping read count update for " + context.folderType());
        } else if ("true".equals(context.meta().get(MailIndexFields.UNREAD))) {
            context.changeContext().session().logger().info(
                "Skipping read count update for unread mail");
        } else {
            for (Map<String, Object> doc: documents) {
                incrementCounter(doc, MailIndexFields.SENDERS_FROM_READ_COUNT);
            }
        }

        return documents;
    }
}
