package ru.yandex.search.mail.kamaji.senders;

import org.apache.http.HttpException;

import ru.yandex.json.parser.JsonException;
import ru.yandex.search.mail.kamaji.ChangeContext;
import ru.yandex.search.mail.kamaji.subscriptions.SlowIndexModule;
import ru.yandex.search.mail.kamaji.subscriptions.SlowIndexModuleFactory;

public enum SendersIndexerModuleFactory implements SlowIndexModuleFactory {
    INSTANCE;

    @Override
    public SlowIndexModule create(final ChangeContext context)
        throws HttpException, JsonException
    {
        SlowIndexModule module = null;
        if (context.slow()) {
            switch (context.changeType()) {
                case STORE:
                    module = StoreSendersIndexerModule.INSTANCE;
                    break;
                case REINDEX:
                    module = ReindexSendersIndexerModule.INSTANCE;
                    break;
                case UPDATE:
                    if (context.markAsRead()) {
                        module = IncrementReadSendersIndexerModule.INSTANCE;
                    }
                    break;
                default:
                    break;
            }
        }

        return module;
    }
}
