package ru.yandex.search.mail.kamaji.sherlock;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpException;

import ru.yandex.dbfields.ChangeType;
import ru.yandex.dbfields.MailIndexFields;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.document.mail.MailMetaInfo;
import ru.yandex.search.mail.kamaji.ChangeContext;
import ru.yandex.search.mail.kamaji.KamajiIndexationContext;
import ru.yandex.search.mail.kamaji.subscriptions.IndexModule;
import ru.yandex.search.mail.kamaji.subscriptions.IndexModuleFactory;

/**
 * Created for IEX-1936, index sherlock template id for mid
 */
public enum SherlockTemplatedIdIndexerFactory
    implements IndexModule, IndexModuleFactory
{
    INSTANCE;

    private static final List<String> PRESERVE_FIELDS =
        Collections.singletonList(MailIndexFields.SHERLOCK_TEMPLATES);

    @Override
    public List<Map<String, Object>> indexDocuments(
        final KamajiIndexationContext context)
    {
        Map<String, Object> doc = new LinkedHashMap<>();
        StringBuilder sb = new StringBuilder("shrlck_");
        sb.append(context.prefix());
        sb.append('_');
        sb.append(context.meta().get(MailMetaInfo.STID));

        doc.put(MailIndexFields.URL, sb.toString());
        doc.put(
            MailIndexFields.SHERLOCK_MID,
            context.meta().get(MailMetaInfo.MID));

        return Collections.singletonList(doc);
    }

    @Override
    public Collection<String> preserveFields() {
        return PRESERVE_FIELDS;
    }

    @Override
    public IndexModule create(final ChangeContext context)
        throws HttpException, JsonException
    {
        if (!context.slow() && context.changeType() == ChangeType.STORE) {
            return INSTANCE;
        }

        return null;
    }
}
