package ru.yandex.search.mail.kamaji.subscriptions;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.http.HttpException;

import ru.yandex.dbfields.MailIndexFields;
import ru.yandex.json.parser.JsonException;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.search.document.mail.MailMetaInfo;
import ru.yandex.search.mail.kamaji.ChangeContext;
import ru.yandex.search.mail.kamaji.KamajiIndexationContext;

public class SubsMailActionModuleFactory implements IndexModuleFactory {
    private final Set<String> preservedFields;
    private final boolean newFormat;

    public SubsMailActionModuleFactory(final Set<String> preservedFields, final boolean newFormat) {
        this.preservedFields = preservedFields;
        this.newFormat = newFormat;
    }

    @Override
    public IndexModule create(final ChangeContext context)
        throws HttpException, JsonException
    {
        return new SubsMailActionModule(context.session().logger());
    }

    private final class SubsMailActionModule extends SubsBaseModule {
        private SubsMailActionModule(
            final PrefixedLogger logger)
        {
            super(logger, preservedFields, newFormat);
        }

        @Override
        public List<Map<String, Object>> indexDocuments(
            final KamajiIndexationContext context)
        {
            MailMetaInfo meta = context.meta();

            String mid = meta.get(MailMetaInfo.MID);
            String metaFid = meta.get(MailMetaInfo.FID);
            boolean skip;
            String currentIndexFid =
                context.auxillary().get(MailIndexFields.FID);
            if (currentIndexFid == null) {
                // our click is faster than store, ok, accept that
                logger.info("ClickFasterThanStore " + metaFid + ' ' + mid);
                skip = true;
            } else {
                if (!currentIndexFid.equalsIgnoreCase(metaFid)) {
                    logger.info("ClickFasterThanMove"
                        + metaFid + ' ' + context.folderType() + ' ' + mid);
                }

                skip = !goodFolderType(context);
                if (skip) {
                    logger.info("Subscriptions action bad folder type "
                        + context.folderType());
                }
            }

            if (skip) {
                return Collections.emptyList();
            } else {
                logger.info("Increasing read for "
                    + context.mid() + ' '
                    + context.folderType());
            }

            if (newFormat && !NewSubscriptionsModuleFactory.indexableSubscription(meta)) {
                return Collections.emptyList();
            }

            List<Integer> types = sortedTypes(meta);
            String read = typesToMap(types, 1L);
            return super.indexDocuments(context, read, "");
        }
    }
}
