package ru.yandex.search.mail.kamaji.subscriptions;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.http.HttpException;

import ru.yandex.dbfields.PgFields;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.xpath.ValueUtils;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.search.document.mail.MailMetaInfo;
import ru.yandex.search.mail.kamaji.ChangeContext;
import ru.yandex.search.mail.kamaji.KamajiIndexationContext;

public class SubsStoreIndexModuleFactory implements IndexModuleFactory {
    private final Set<String> preservedFields;
    private final boolean newFormat;

    public SubsStoreIndexModuleFactory(
        final Set<String> preservedFields,
        final boolean newFormat)
    {
        this.preservedFields = preservedFields;
        this.newFormat = newFormat;
    }

    @Override
    public IndexModule create(final ChangeContext context)
        throws HttpException, JsonException
    {
        Set<String> mids = new LinkedHashSet<>();
        for (Object docObj
            : ValueUtils.asList(context.json().get(PgFields.CHANGED)))
        {
            Map<?, ?> doc = ValueUtils.asMap(docObj);
            String mid = ValueUtils.asString(doc.get(PgFields.MID));
            mids.add(mid);
        }

        if (mids.isEmpty()) {
            context.session().logger().info(
                "Subscriptions no inbox mids, skipping");
            return null;
        }

        return new SubsStoreIndexModule(mids, context.session().logger());
    }

    private final class SubsStoreIndexModule
        extends SubsBaseModule
    {
        private final Set<String> mids;

        private SubsStoreIndexModule(
            final Set<String> mids,
            final PrefixedLogger logger)
        {
            super(logger, preservedFields, newFormat);

            this.mids = mids;
        }

        @Override
        public List<Map<String, Object>> indexDocuments(
            final KamajiIndexationContext context)
        {
            MailMetaInfo meta = context.meta();
            boolean skip = !goodFolderType(context);
            if (skip) {
                logger.info("Subscriptions store bad folder type "
                    + context.folderType());
            } else if (!mids.contains(meta.get(MailMetaInfo.MID))
                    || meta.messageTypes().isEmpty())
            {
                logger.info(
                    "Subscriptions mid is not in list, "
                        + "or types are empty " + mids
                        + ' ' + meta.messageTypes());
                skip = true;
            }

            if (skip) {
                return Collections.emptyList();
            }

            if (newFormat && !NewSubscriptionsModuleFactory.indexableSubscription(meta)) {
                return Collections.emptyList();
            }

            List<Integer> types = sortedTypes(meta);

            String received = typesToMap(types, 1L);
            return super.indexDocuments(context, "", received);
        }
    }
}
