package ru.yandex.search.mail.kamaji.update;

import java.util.concurrent.atomic.AtomicBoolean;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.EmptyFutureCallback;
import ru.yandex.search.mail.kamaji.Kamaji;
import ru.yandex.search.mail.kamaji.lock.FastSlowLock;

public abstract class AbstractLockReleaseCallback<T>
    implements FutureCallback<T>
{
    protected final FutureCallback<Object> callback;
    protected final Kamaji kamaji;
    protected final FastSlowLock lock;
    private final AtomicBoolean done = new AtomicBoolean(false);

    protected AbstractLockReleaseCallback(
        final Kamaji kamaji,
        final FutureCallback<Object> callback,
        final FastSlowLock lock)
    {
        this.callback = callback;
        this.kamaji = kamaji;
        this.lock = lock;
    }

    protected abstract void releaseLock();

    private FutureCallback<Object> callback() {
        if (done.compareAndSet(false, true)) {
            releaseLock();
            return callback;
        } else {
            return EmptyFutureCallback.INSTANCE;
        }
    }

    @Override
    public void completed(final T o) {
        callback().completed(o);
    }

    @Override
    public void failed(final Exception e) {
        callback().failed(e);
    }

    @Override
    public void cancelled() {
        callback().cancelled();
    }
}
