package ru.yandex.search.mail.kamaji.update;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;

import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.search.document.mail.MailMetaInfo;

public interface IndexationContext {
    MailMetaInfo meta();

    String url(final String hid);

    Collection<String> preserveFields();

    default Collection<String> preserveSlowFields() {
        return Collections.emptyList();
    }

    Map<?, ?> updates();

    long prefix();

    AsyncClient indexClient();

    default Map<String, String> auxillary() {
        return Collections.emptyMap();
    }

    // Return time frame queue for mail text part length
    // Can be null consumer, if this mail don't match any filters,
    // like corp/pdd/web or inbox/sent
    Consumer<? super Integer> textLengthConsumer();
}
