package ru.yandex.search.mail.kamaji.update.fast;

import java.util.Collections;
import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.dbfields.MailIndexFields;
import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.search.mail.kamaji.ChangeContext;
import ru.yandex.search.mail.kamaji.Kamaji;
import ru.yandex.search.mail.kamaji.lock.FastSlowLock.LockAcquireStatus;
import ru.yandex.search.proxy.SearchResultConsumerFactory;
import ru.yandex.search.result.SearchResult;
import ru.yandex.util.string.StringUtils;

public class FastFetchIndexStateLockCallback
    implements FutureCallback<LockAcquireStatus>
{
    private static final String GET =
        "&get=" + MailIndexFields.CLICKS + ',' + MailIndexFields.FID;

    private final FastMailPreparedCallback fastPreparedCallback;
    private final AsyncClient client;
    private final ChangeContext context;
    private final String mid;

    public FastFetchIndexStateLockCallback(
        final String mid,
        final ChangeContext context,
        final FastMailPreparedCallback callback)
    {
        this.context = context;
        this.mid = mid;

        this.client =
            context.kamaji().searchClient().adjust(
                context.session().context());
        this.fastPreparedCallback = callback;
    }

    @Override
    public void completed(final LockAcquireStatus status) {
        // hack for subscriptions
        String url =
            StringUtils.concat(
                String.valueOf(
                    context.prefix()), '_', mid, "/0");
        StringBuilder uri = new StringBuilder("/search?IO_PRIO=");
        uri.append(Kamaji.IOPRIO);
        uri.append("&prefix=");
        uri.append(context.prefix());
        uri.append("&text=url:");
        uri.append(url);
        uri.append(GET);

        client.execute(
            context.kamaji().config().searchConfig().host(),
            new BasicAsyncRequestProducerGenerator(uri.toString()),
            SearchResultConsumerFactory.OK,
            context.session().listener()
                .createContextGeneratorFor(client),
            new IndexStateFetchCallback(fastPreparedCallback, status));
    }

    @Override
    public void failed(final Exception e) {
        fastPreparedCallback.failed(e);
    }

    @Override
    public void cancelled() {
        fastPreparedCallback.cancelled();
    }

    private final class IndexStateFetchCallback
        extends AbstractFilterFutureCallback<SearchResult, LockAcquireStatus>
    {
        private final LockAcquireStatus status;

        private IndexStateFetchCallback(
            final FutureCallback<? super LockAcquireStatus> callback,
            final LockAcquireStatus status)
        {
            super(callback);

            this.status = status;
        }

        @Override
        public void completed(final SearchResult result) {
            Map<String, String> indexData;
            if (result.hitsArray().size() >= 1) {
                indexData = result.hitsArray().get(0).attrs();
            } else {
                indexData = Collections.emptyMap();
            }

            fastPreparedCallback.completed(status, indexData);
        }

        @Override
        public void cancelled() {
            fastPreparedCallback.releaseLock();
            super.cancelled();
        }

        @Override
        public void failed(final Exception e) {
            fastPreparedCallback.releaseLock();
            super.failed(e);
        }
    }
}
