package ru.yandex.search.mail.kamaji.update.fast;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.dbfields.PgFields;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;
import ru.yandex.search.mail.kamaji.OffsetCallback;
import ru.yandex.search.mail.kamaji.lock.FastSlowLock;
import ru.yandex.search.mail.kamaji.lock.FastSlowLock.LockAcquireStatus;
import ru.yandex.search.mail.kamaji.lock.FastSlowLock.LockRequest;
import ru.yandex.search.mail.kamaji.lock.FastSlowLock.LockerType;
import ru.yandex.search.mail.kamaji.update.AbstractFilterSearchCallback;
import ru.yandex.util.string.StringUtils;

public class FastFilterSearchCallback
    extends AbstractFilterSearchCallback<FastMailPreparedCallback>
{
    private final OffsetCallback offsetCallback;
    private final FastKamajiIndexationContextFactory contextFactory;

    public FastFilterSearchCallback(
        final OffsetCallback offsetCallback,
        final String uri,
        final BlackboxUserinfo userinfo)
        throws JsonUnexpectedTokenException
    {
        super(offsetCallback, uri);

        this.offsetCallback = offsetCallback;
        this.contextFactory =
            new FastKamajiIndexationContextFactory(
                context,
                userinfo,
                offsetCallback.indexClient());

        MultiFutureCallback<Object> midsCallback =
            new MultiFutureCallback<>(offsetCallback);

        try {
            processChanged(midsCallback);
        } catch (Exception e) {
            failed(e);
        } finally {
            midsCallback.done();
        }
    }

    private void processChanged(
        final MultiFutureCallback<Object> midsCallback)
        throws JsonUnexpectedTokenException
    {
        for (int i = 0; i < offsetCallback.batchSize(); ++i) {
            String mid =
                ValueUtils.asString(
                    ValueUtils.asMap(
                        offsetCallback.changed()
                            .get(i + context.offset()))
                        .get(PgFields.MID));

            String key =
                StringUtils.concat(
                    String.valueOf(context.prefix()), "_m", mid);

            FastSlowLock lock =
                context.kamaji().lockManager().acquire(
                    key,
                    new FastSlowLock(context.zooQueueId(), key));

            FastMailPreparedCallback callback =
                new FastMailPreparedCallback(
                    contextFactory,
                    midsCallback.newCallback(),
                    lock);

            FutureCallback<LockAcquireStatus> lockCallback;
            if (context.fetchClicks()) {
                // subscriptions hook,
                // we need to know current mid clicks on move
                // we need current fid, on click handle, in case of race
                lockCallback =
                    new FastFetchIndexStateLockCallback(mid, context, callback);
            } else {
                lockCallback = callback;
            }

            LockAcquireStatus status =
                lock.lock(
                    new LockRequest(
                        LockerType.FAST,
                        context.zooQueueId(),
                        lockCallback),
                    context);

            this.callbackMap.put(mid, callback);

            if (status == LockAcquireStatus.SKIP) {
                failed(
                    new IllegalStateException(
                        "Fast document lock can not be skipped " + key));
                return;
            }

            if (status == LockAcquireStatus.LOCKED) {
                lockCallback.completed(null);
            }
        }

        midsCallback.done();
    }
}
