package ru.yandex.search.mail.kamaji.update.fast;

import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.http.util.NotFoundException;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.search.document.mail.MailMetaInfo;
import ru.yandex.search.mail.kamaji.ChangeContext;
import ru.yandex.search.mail.kamaji.KamajiIndexationContext;
import ru.yandex.search.mail.kamaji.update.IndexationContextFactory;

public class FastKamajiIndexationContextFactory
    implements IndexationContextFactory<KamajiIndexationContext>
{
    private final ChangeContext context;
    private final AsyncClient indexClient;
    private final BlackboxUserinfo userinfo;

    public FastKamajiIndexationContextFactory(
        final ChangeContext context,
        final BlackboxUserinfo userinfo,
        final AsyncClient indexClient)
    {
        this.context = context;
        this.indexClient = indexClient;
        this.userinfo = userinfo;
    }

    public ChangeContext changeContext() {
        return context;
    }

    @Override
    public KamajiIndexationContext create(
        final MailMetaInfo meta,
        final Map<String, String> auxillary,
        final FutureCallback<Object> callback)
        throws JsonUnexpectedTokenException, NotFoundException
    {
        return new KamajiIndexationContext(
            context,
            indexClient,
            meta,
            userinfo,
            auxillary,
            callback);
    }
}
