package ru.yandex.search.mail.kamaji.update.fast;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.search.mail.kamaji.ChangeContext;
import ru.yandex.search.mail.kamaji.lock.FastSlowLock;
import ru.yandex.search.mail.kamaji.update.AbstractLockReleaseCallback;

public class FastMailCallback extends AbstractLockReleaseCallback<Object> {
    private ChangeContext context;

    public FastMailCallback(
        final ChangeContext context,
        final FutureCallback<Object> callback,
        final FastSlowLock lock)
    {
        super(context.kamaji(), callback, lock);
        this.context = context;
    }

    @Override
    protected void releaseLock() {
        kamaji.lockManager().release(lock.key());
        lock.unlock(context);
    }
}
