package ru.yandex.search.mail.kamaji.update.fast;

import java.util.Collections;
import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.NotFoundException;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.search.document.mail.MailMetaInfo;
import ru.yandex.search.mail.kamaji.ChangeContext;
import ru.yandex.search.mail.kamaji.KamajiIndexationContext;
import ru.yandex.search.mail.kamaji.KamajiIndexer;
import ru.yandex.search.mail.kamaji.lock.FastSlowLock;
import ru.yandex.search.mail.kamaji.lock.FastSlowLock.LockAcquireStatus;
import ru.yandex.search.mail.kamaji.update.IndexationContextFactory;
import ru.yandex.search.mail.kamaji.update.MailPreparedCallback;

public class FastMailPreparedCallback
    implements FutureCallback<LockAcquireStatus>, MailPreparedCallback
{
    private final FutureCallback<Object> callback;
    private final FastSlowLock lock;
    private final IndexationContextFactory<KamajiIndexationContext> factory;
    private final ChangeContext context;

    private boolean done = false;
    private boolean holdingLock = false;
    private MailMetaInfo meta;
    private Map<String, String> indexAttrs = null;

    public FastMailPreparedCallback(
        final FastKamajiIndexationContextFactory contextFactory,
        final FutureCallback<Object> callback,
        final FastSlowLock lock)
    {
        this.callback = callback;
        this.lock = lock;

        this.factory = contextFactory;
        this.context = contextFactory.changeContext();
    }

    @Override
    public void metaReady(final MailMetaInfo meta) {
        this.meta = meta;

        complete();
    }

    @Override
    public void metaGone() {
        if (cleanup()) {
            callback.completed(null);
        }
    }

    public void completed(
        final LockAcquireStatus o,
        final Map<String, String> attrs)
    {
        // Weird findbugs without such lame sync block
        // crying about insufficient sync of holding lock
        // if you understand why he is right, please tell me
        boolean stale = false;
        synchronized (this) {
            this.holdingLock = true;
            this.indexAttrs = attrs;
            if (done) {
                stale = true;
            }
        }

        if (stale) {
            releaseLock();
            return;
        }

        complete();
    }

    @Override
    public void completed(final LockAcquireStatus o) {
        completed(o, null);
    }

    private void complete() {
        Map<String, String> auxillaryData;
        synchronized (this) {
            if (done || !holdingLock || this.meta == null) {
                return;
            }

            done = true;
            // we can not put it in meta,
            // bacause it's not supposed to be indexed
            if (indexAttrs != null) {
                auxillaryData = indexAttrs;
            } else {
                auxillaryData = Collections.emptyMap();
            }
        }

        KamajiIndexationContext indexationContext;
        FastMailCallback fmCallback
            = new FastMailCallback(context, callback, lock);
        try {
            indexationContext = factory.create(meta, auxillaryData, fmCallback);
            KamajiIndexer.indexDocument(indexationContext);
        } catch (JsonUnexpectedTokenException | NotFoundException e) {
            fmCallback.failed(e);
            return;
        } catch (RuntimeException re) {
            fmCallback.failed(re);
            throw re;
        }
    }

    protected void releaseLock() {
        context.kamaji().lockManager().release(lock.key());
        lock.unlock(context);
    }

    protected boolean cleanup() {
        boolean needUnlock;

        synchronized (this) {
            if (done) {
                return false;
            }

            done = true;
            needUnlock = holdingLock;
        }

        if (needUnlock) {
            releaseLock();
        }

        return true;
    }

    @Override
    public void cancelled() {
        callback.cancelled();

        cleanup();
    }

    @Override
    public void failed(final Exception e) {
        callback.failed(e);

        cleanup();
    }
}
