package ru.yandex.search.mail.kamaji.update.slow;

import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.search.mail.kamaji.AbstractCallback;
import ru.yandex.search.mail.kamaji.KamajiIndexationContext;

public class CleanupCallback extends AbstractCallback<Object> {
    private final List<String> urls;

    public CleanupCallback(
        final KamajiIndexationContext context,
        final FutureCallback<Object> callback,
        final List<String> urls)
    {
        super(context, callback);

        this.urls = urls;
    }

    @Override
    public void completed(final Object result) {
        StringBuilder sb = new StringBuilder("/delete?prefix=");
        sb.append(context.changeContext().prefix());
        sb.append("&text=mid_p:");
        sb.append(context.mid());
        sb.append("+AND+NOT+url:(");
        for (int i = 0; i < urls.size(); ++i) {
            if (i != 0) {
                sb.append("+OR+");
            }
            sb.append(urls.get(i));
        }
        sb.append(')');

        AsyncClient client = context
            .changeContext()
            .kamaji()
            .backendClient()
            .adjust(context.changeContext().session().context());
        client.execute(
            context.changeContext().kamaji().backendHost(),
            new BasicAsyncRequestProducerGenerator(new String(sb)),
            EmptyAsyncConsumerFactory.ANY_GOOD,
            context.changeContext().session().listener()
                .createContextGeneratorFor(client),
            callback);
    }
}
