package ru.yandex.search.mail.kamaji.update.slow;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import ru.yandex.dbfields.MailIndexFields;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;
import ru.yandex.search.document.mail.MailMetaInfo;
import ru.yandex.search.mail.kamaji.KamajiIndexationContext;
import ru.yandex.search.mail.kamaji.KamajiIndexer;
import ru.yandex.search.mail.kamaji.subscriptions.SlowIndexModule;

public class SlowDocumentProvider {
    protected static final String DOCS = "docs";

    public List<String> apply(
        final Object tikaiteResult,
        final JsonWriter writer,
        final KamajiIndexationContext context)
        throws IOException, JsonUnexpectedTokenException
    {
        List<String> urls = new ArrayList<>();
        urls.add(context.url(MailMetaInfo.ZERO_HID));

        if (tikaiteResult instanceof Throwable) {
            writer.startObject();
            // Fast document will get mid from meta
            // Also prelude will write prefix field to root object
            KamajiIndexer.writeFastDocumentWithPrelude(writer, context);
            writer.key(MailIndexFields.TIKAITE_ERROR);
            writer.value(tikaiteResult);
            writer.endObject();
        } else {
            Map<?, ?> json = ValueUtils.asMap(tikaiteResult);
            List<?> docs = ValueUtils.asList(json.remove(DOCS));
            writer.startObject();

            writer.key("prefix");
            writer.value(context.prefix());

            // Nothing should left in the `result' object by now
            // Let's write preserve fields and other stuff
            KamajiIndexer.writePreserveFields(writer, context);

            writer.key(DOCS);
            writer.startArray();
            writer.startObject();
            // write fast part
            KamajiIndexer.writeFastFields(writer, context);
            // write slow part
            writer.endObject();

            for (SlowIndexModule module
                : context.changeContext().slowSubIndexers())
            {
                for (Map<String, Object> doc
                    : module.indexDocuments(context, docs))
                {
                    writer.value(doc);
                }
            }

            Map<String, String> fields = context.meta().toMap();
            int pureBodyLength = -1;

            for (Object docObject : docs) {
                writer.startObject();
                for (Map.Entry<String, String> entry : fields.entrySet()) {
                    writer.key(entry.getKey());
                    writer.value(entry.getValue());
                }

                Map<?, ?> doc = ValueUtils.asMap(docObject);
                // Mid will be already taken from meta
                // We will write our own url
                doc.remove(MailIndexFields.URL);

                for (Map.Entry<?, ?> entry : doc.entrySet()) {
                    Object key = entry.getKey();
                    if (!fields.containsKey(key)) {
                        writer.key(key.toString());
                        String value = entry.getValue().toString();
                        writer.value(value);
                        if (MailIndexFields.HID.equals(key)) {
                            String url = context.url(value);
                            writer.key(MailIndexFields.URL);
                            writer.value(url);
                            urls.add(url);
                        } else if (pureBodyLength == -1
                            && MailIndexFields.PURE_BODY.equals(key))
                        {
                            pureBodyLength = value.length();
                        }
                    }
                }
                writer.endObject();
                doc.clear();
            }
            if (pureBodyLength != -1) {
                context.textLengthConsumer().accept(pureBodyLength);
            }
        }

        writer.endArray();
        writer.endObject();

        return urls;
    }
}
