package ru.yandex.search.mail.kamaji.update.slow;

import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.dbfields.PgFields;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;
import ru.yandex.search.mail.kamaji.Kamaji;
import ru.yandex.search.mail.kamaji.OffsetCallback;
import ru.yandex.search.mail.kamaji.lock.FastSlowLock;
import ru.yandex.search.mail.kamaji.update.AbstractFilterSearchCallback;
import ru.yandex.search.proxy.SearchResultConsumerFactory;
import ru.yandex.util.string.StringUtils;

public class SlowFilterSearchCallback
    extends AbstractFilterSearchCallback<SlowMailPreparedCallback>
{
    private final OffsetCallback offsetCallback;
    private final SlowKamajiIndexationContextFactory contextFactory;

    public SlowFilterSearchCallback(
        final OffsetCallback offsetCallback,
        final String uri,
        final BlackboxUserinfo userinfo)
    {
        super(offsetCallback, uri);

        this.offsetCallback = offsetCallback;

        this.contextFactory =
            new SlowKamajiIndexationContextFactory(
                context,
                userinfo,
                offsetCallback.indexClient());

        MultiFutureCallback<Object> midsCallback =
            new MultiFutureCallback<>(offsetCallback);

        try {
            processChanged(midsCallback);
        } catch (Exception e) {
            failed(e);
        } finally {
            midsCallback.done();
        }
    }

    private void processChanged(
        final MultiFutureCallback<Object> midsCallback)
        throws JsonUnexpectedTokenException
    {
        AsyncClient searchClient =
            context.kamaji().searchClient().adjust(
                context.session().context());

        StringBuilder sb = new StringBuilder("/search?IO_PRIO="
            + Kamaji.IOPRIO
            + "&prefix=");
        sb.append(context.prefix());
        sb.append("&get=mid,queueId&text=url:");
        sb.append(context.prefix());
        sb.append('_');

        String queryBase = new String(sb);

        for (int i = 0; i < offsetCallback.batchSize(); ++i) {
            String mid =
                ValueUtils.asString(
                    ValueUtils.asMap(
                        offsetCallback.changed()
                            .get(i + context.offset()))
                        .get(PgFields.MID));
            String key =
                StringUtils.concat(
                    String.valueOf(context.prefix()), "_m", mid);

            FastSlowLock lock =
                context.kamaji().lockManager().acquire(
                    key,
                    new FastSlowLock(context.zooQueueId(), key));

            SlowMailPreparedCallback callback =
                new SlowMailPreparedCallback(
                    contextFactory,
                    midsCallback.newCallback(),
                    lock);

            this.callbackMap.put(mid, callback);

            String url = StringUtils.concat(queryBase, mid, "/0");
            searchClient.execute(
                context.kamaji().config().searchConfig().host(),
                new BasicAsyncRequestProducerGenerator(url),
                SearchResultConsumerFactory.OK,
                context.session().listener()
                    .createContextGeneratorFor(searchClient),
                callback);
        }

        midsCallback.done();
    }
}
