package ru.yandex.search.mail.kamaji.update.slow;

import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;
import ru.yandex.http.util.nio.NByteArrayEntityGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.search.document.mail.MailMetaInfo;
import ru.yandex.search.mail.kamaji.ChangeContext;
import ru.yandex.search.mail.kamaji.Kamaji;
import ru.yandex.search.mail.kamaji.lock.FastSlowLock;
import ru.yandex.search.mail.kamaji.lock.FastSlowLock.LockAcquireStatus;
import ru.yandex.search.mail.kamaji.update.AbstractLockReleaseCallback;
import ru.yandex.search.proxy.SearchResultConsumerFactory;
import ru.yandex.search.result.SearchResult;

public class SlowLockCallback implements FutureCallback<LockAcquireStatus> {
    private final TikaiteContext tikaiteContext;
    private final FutureCallback<Object> callback;

    public SlowLockCallback(
        final TikaiteContext tikaiteContext,
        final FutureCallback<Object> callback)
    {
        this.tikaiteContext = tikaiteContext;
        this.callback = callback;
    }

    @Override
    public void completed(final LockAcquireStatus s) {
        if (s != LockAcquireStatus.LOCKED) {
            tikaiteContext.changeContext().session().logger().info(
                "LockReject, more fresh notify came "
                    + tikaiteContext.lock().key());

            callback.completed(null);
            return;
        }
        // we are locked, so we should unlock anyway
        UnlockCallback unlockCallback =
            new UnlockCallback(
                tikaiteContext.changeContext(),
                callback,
                tikaiteContext.lock());

        AsyncClient searchClient =
            tikaiteContext.kamaji().searchClient().adjust(
                tikaiteContext.changeContext().session().context());

        StringBuilder sb = new StringBuilder("/search?IO_PRIO="
            + Kamaji.IOPRIO + "&prefix=");
        sb.append(tikaiteContext.changeContext().prefix());
        sb.append("&get=mid,queueId&text=url:");
        sb.append(tikaiteContext.context().meta().url(MailMetaInfo.ZERO_HID));

        tikaiteContext.changeContext().session().subscribeForCancellation(
            searchClient.execute(
                tikaiteContext.kamaji().config().searchConfig().host(),
                new BasicAsyncRequestProducerGenerator(sb.toString()),
                SearchResultConsumerFactory.OK,
                tikaiteContext.changeContext().session().listener()
                    .createContextGeneratorFor(searchClient),
                new CheckIndexCallback(unlockCallback, tikaiteContext)));
    }

    @Override
    public void failed(final Exception e) {
        callback.failed(e);
    }

    @Override
    public void cancelled() {
        callback.cancelled();
    }

    private static final class CheckIndexCallback
        extends AbstractFilterFutureCallback<SearchResult, Object>
    {
        private final TikaiteContext tikaiteContext;

        private CheckIndexCallback(
            final FutureCallback<? super Object> callback,
            final TikaiteContext tikaiteContext)
        {
            super(callback);

            this.tikaiteContext = tikaiteContext;
        }

        @Override
        public void completed(final SearchResult result) {
            if (result.hitsCount() <= 0) {
                tikaiteContext.changeContext().session().logger().info(
                    "DataSkip, not index "
                        + tikaiteContext.context().mid()
                        + " skipping");
                callback.completed(null);
                return;
            }

            ChangeContext changeContext = tikaiteContext.changeContext();

            tikaiteContext.changeContext().session().subscribeForCancellation(
                tikaiteContext.client().execute(
                    changeContext.kamaji().backendHost(),
                    new BasicAsyncRequestProducerGenerator(
                        "/update?" + changeContext.userTag()
                            + "&mid=" + tikaiteContext.context().mid(),
                        new NByteArrayEntityGenerator(
                            tikaiteContext.out(),
                            ContentType.APPLICATION_JSON.withCharset(
                                tikaiteContext.client().requestCharset()))),
                    EmptyAsyncConsumerFactory.ANY_GOOD,
                    changeContext.session().listener()
                        .createContextGeneratorFor(tikaiteContext.client()),
                    new CleanupCallback(
                        tikaiteContext.context(),
                        callback,
                        tikaiteContext.urls())));
        }
    }

    private static final class UnlockCallback
        extends AbstractLockReleaseCallback<Object>
    {
        private final ChangeContext changeContext;

        private UnlockCallback(
            final ChangeContext context,
            final FutureCallback<Object> callback,
            final FastSlowLock lock)
        {
            super(context.kamaji(), callback, lock);

            this.changeContext = context;
        }

        @Override
        protected void releaseLock() {
            // just unlocking, releasing in upper callback
            lock.unlock(changeContext);
        }
    }
}
