package ru.yandex.search.mail.kamaji.update.slow;

import java.util.Collections;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.NotFoundException;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.search.document.mail.MailMetaInfo;
import ru.yandex.search.mail.kamaji.ChangeContext;
import ru.yandex.search.mail.kamaji.KamajiIndexationContext;
import ru.yandex.search.mail.kamaji.lock.FastSlowLock;
import ru.yandex.search.mail.kamaji.update.MailPreparedCallback;
import ru.yandex.search.result.SearchResult;

public class SlowMailPreparedCallback
    implements FutureCallback<SearchResult>, MailPreparedCallback
{
    private final FutureCallback<Object> callback;
    private final FastSlowLock lock;
    private final SlowKamajiIndexationContextFactory contextFactory;
    private final ChangeContext context;

    private boolean done = false;

    private SearchResult searchResult;
    private MailMetaInfo meta;

    public SlowMailPreparedCallback(
        final SlowKamajiIndexationContextFactory contextFactory,
        final FutureCallback<Object> callback,
        final FastSlowLock lock)
    {
        this.callback = callback;
        this.lock = lock;
        this.contextFactory = contextFactory;
        this.context = contextFactory.changeContext();
    }

    @Override
    public void metaReady(final MailMetaInfo meta) {
        this.meta = meta;

        complete();
    }

    @Override
    public void metaGone() {
        if (cleanup()) {
            callback.completed(null);
        }
    }

    @Override
    public void completed(final SearchResult result) {
        this.searchResult = result;

        complete();
    }

    //CSOFF: ReturnCount
    private void complete() {
        synchronized (this) {
            if (done || searchResult == null || meta == null) {
                return;
            }

            done = true;
        }

        SlowMailCallback slowMailCallback =
            new SlowMailCallback(context.kamaji(), callback, lock);

        KamajiIndexationContext indexationContext;
        try {
            indexationContext =
                contextFactory.create(
                    meta,
                    Collections.emptyMap(),
                    slowMailCallback);
        } catch (JsonUnexpectedTokenException | NotFoundException e) {
            slowMailCallback.failed(e);
            return;
        }

        if (searchResult.hitsCount() <= 0) {
            context.session().logger().info(
                "DataSkip delete between fast and slow for " + lock.key());
            slowMailCallback.completed(null);
        } else {
            long lastQueueId = -1;
            try {
                String queueIdStr =
                    searchResult.hitsArray().get(0).attrs().get("queueId");
                if (queueIdStr == null) {
                    context.session().logger().warning(
                        "QueueId is null for " + indexationContext.mid());
                } else {
                    lastQueueId = Long.parseLong(queueIdStr);
                }
            } catch (NumberFormatException nfe) {
                slowMailCallback.failed(nfe);
                return;
            }

            if (lastQueueId > context.zooQueueId()) {
                context.session().logger().info(
                    "DataSkip " + indexationContext.mid()
                        + " current queueId is " + context.zooQueueId()
                        + " but already indexed " + lastQueueId);
                slowMailCallback.completed(null);
            } else {
                context.kamaji().sendTikaiteRequest(indexationContext, lock);
//                context.kamaji().sendTikaiteRequest(
//                    context.session(),
//                    indexationContext.stid(),
//                    new TikaiteCallback(indexationContext, lock));
            }
        }
    }
    //CSON:ReturnCount

    private void releaseLock() {
        context.kamaji().lockManager().release(lock.key());
    }

    protected boolean cleanup() {
        synchronized (this) {
            if (done) {
                return false;
            }

            done = true;
        }

        releaseLock();

        return true;
    }

    @Override
    public void cancelled() {
        callback.cancelled();

        cleanup();
    }

    @Override
    public void failed(final Exception e) {
        callback.failed(e);

        cleanup();
    }
}
