package ru.yandex.search.mail.kamaji.update.slow;

import java.util.List;

import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.io.DecodableByteArrayOutputStream;
import ru.yandex.search.mail.kamaji.ChangeContext;
import ru.yandex.search.mail.kamaji.Kamaji;
import ru.yandex.search.mail.kamaji.KamajiIndexationContext;
import ru.yandex.search.mail.kamaji.lock.FastSlowLock;

public class TikaiteContext {
    private FastSlowLock lock;
    private KamajiIndexationContext context;
    private AsyncClient client;
    private List<String> urls;
    private DecodableByteArrayOutputStream out;

    public TikaiteContext(
        final FastSlowLock lock,
        final KamajiIndexationContext context)
    {
        this.lock = lock;
        this.context = context;
    }

    public AsyncClient client() {
        return client;
    }

    public TikaiteContext client(
        final AsyncClient client)
    {
        this.client = client;
        return this;
    }

    public List<String> urls() {
        return urls;
    }

    public TikaiteContext urls(final List<String> urls) {
        this.urls = urls;
        return this;
    }

    public DecodableByteArrayOutputStream out() {
        return out;
    }

    public TikaiteContext out(final DecodableByteArrayOutputStream out) {
        this.out = out;
        return this;
    }

    public FastSlowLock lock() {
        return lock;
    }

    public ChangeContext changeContext() {
        return context.changeContext();
    }

    public KamajiIndexationContext context() {
        return context;
    }

    public TikaiteContext context(
        final KamajiIndexationContext context)
    {
        this.context = context;
        return this;
    }

    public Kamaji kamaji() {
        return context.changeContext().kamaji();
    }
}
