package ru.yandex.search.mail.kamaji.usertype;

public class ImmutableUserTypeConfig implements UserTypeConfig {
    private final boolean enabled;
    private final int batchSize;

    public ImmutableUserTypeConfig(final UserTypeConfig config) {
        this.enabled = config.enabled();
        this.batchSize = config.reindexBatchSize();
    }

    @Override
    public boolean enabled() {
        return enabled;
    }

    @Override
    public int reindexBatchSize() {
        return batchSize;
    }
}
