package ru.yandex.search.mail.kamaji.usertype;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class UserTypeConfigBuilder implements UserTypeConfig {
    private boolean enabled;
    private int reindexBatchSize;

    public UserTypeConfigBuilder() {
        this(UserTypeConfigDefaults.INSTANCE);
    }

    public UserTypeConfigBuilder(final UserTypeConfig config) {
        this.enabled = config.enabled();
        this.reindexBatchSize = config.reindexBatchSize();
    }

    public UserTypeConfigBuilder(
        final IniConfig config,
        final UserTypeConfig defaults)
        throws ConfigException
    {
        this.enabled = config.getBoolean("enabled", defaults.enabled());
        this.reindexBatchSize =
            config.getInt("reindex-batch-size", defaults.reindexBatchSize());
    }

    @Override
    public boolean enabled() {
        return enabled;
    }

    public UserTypeConfigBuilder enabled(final boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public UserTypeConfigBuilder reindexBatchSize(final int batchSize) {
        this.reindexBatchSize = batchSize;
        return this;
    }

    @Override
    public int reindexBatchSize() {
        return reindexBatchSize;
    }
}
