package ru.yandex.search.mail.kamaji.usertype;

import java.io.IOException;

import org.apache.http.HttpException;

import ru.yandex.dbfields.MailIndexFields;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;
import ru.yandex.parser.email.MailAliases;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.document.mail.UserTypeFrom;
import ru.yandex.search.mail.kamaji.ChangeContext;
import ru.yandex.search.mail.kamaji.ChangeHandler;

public enum UserTypeHandler implements ChangeHandler {
    INSTANCE;

    private static final String PREFIX = "prefix";

    @Override
    public void handle(final ChangeContext context)
        throws HttpException, JsonException
    {
        String email = null;
        String userType = null;

        try {
            email = ValueUtils.asString(
                context.json().get(
                    MailIndexFields.HDR + MailIndexFields.FROM));
            userType = ValueUtils.asString(
                context.json().get("userType"));
        } catch (JsonUnexpectedTokenException jute) {
            throw new BadRequestException("Missing valid hdr_from", jute);
        }

        StringBuilder info = new StringBuilder("Usertype change for user ");
        info.append(context.prefix());
        info.append(" email ");
        info.append(email);
        info.append(" user_type ");
        info.append(userType);

        context.session().logger().info(info.toString());

        AsyncClient client = context.kamaji().backendClient()
            .adjust(context.session().context());
        client.execute(
            context.kamaji().backendHost(),
            indexRequest(context, email, userType),
            EmptyAsyncConsumerFactory.OK,
            context.session().listener()
                .createContextGeneratorFor(client),
            new UserTypeIndexCallback(context));
    }

    private BasicAsyncRequestProducerGenerator indexRequest(
        final ChangeContext context,
        final String email,
        final String userType)
        throws BadRequestException
    {
        QueryConstructor qc = new QueryConstructor("/update?");
        qc.append(PREFIX, String.valueOf(context.prefix()));
        qc.append("service", "change_log");

        StringBuilderWriter sbWriter = new StringBuilderWriter();
        try (JsonWriter writer = new JsonWriter(sbWriter)) {
            writer.startObject();
            writer.key(PREFIX);
            writer.value(context.prefix());
            writer.key("AddIfNotExists");
            writer.value(true);
            writer.key("docs");
            writer.startArray();
            writer.startObject();
            writer.key("url");
            String normalized = MailAliases.INSTANCE.normalizeEmail(email);
            writer.value(UserTypeFrom.url(context.prefix(), normalized));
            writer.key(MailIndexFields.USER_TYPES);
            writer.value(userType);
            writer.endObject();
            writer.endArray();
            writer.endObject();
        } catch (IOException e) {
            throw new BadRequestException(e);
        }

        return new BasicAsyncRequestProducerGenerator(
            qc.toString(), sbWriter.toString());
    }
}
