package ru.yandex.search.document.mail;

import ru.yandex.dbfields.FilterSearchFields;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;

public class AttachInfo {
    private final String hid;
    private final String contentType;
    private final String filename;
    private final Long size;

    public AttachInfo(final JsonMap json) throws JsonException {
        hid = json.getString(FilterSearchFields.ATTACH_HID, null);
        contentType =
            json.getString(FilterSearchFields.ATTACH_CONTENT_TYPE, null);
        filename =
            json.getString(FilterSearchFields.ATTACH_FILENAME, null);
        size = json.getLong(FilterSearchFields.ATTACH_SIZE, null);
    }

    public String hid() {
        return hid;
    }

    public String contentType() {
        return contentType;
    }

    public String filename() {
        return filename;
    }

    public Long size() {
        return size;
    }
}

